package model.generators;

import model.Box;
import model.IGenerator;

/**
 * A simple debug-use implementation of {@link IGenerator} interface, supporting
 * sizable behavior
 * 
 * @author simone
 *
 */
public class ConcreteBoardGenerator implements IGenerator {

	@Override
	/*
	 * (non-Javadoc)
	 * @see model.IGenerator#getBoardHeight()
	 */
	public int getBoardHeight() {
		return boardHeight;
	}

	@Override
	/*
	 * (non-Javadoc)
	 * @see model.IGenerator#getBoardWidth()
	 */
	public int getBoardWidth() {
		return boardWidth;
	}

	private int boardHeight;
	private int boardWidth;

	/**
	 * Create a new istance of this class, giving the size of the board that
	 * will be generated
	 * 
	 * @param boardHeight
	 * @param boardWidth
	 */
	public ConcreteBoardGenerator(int boardHeight, int boardWidth) {
		super();
		this.boardHeight = boardHeight;
		this.boardWidth = boardWidth;
	}

	@Override
	/*
	 * (non-Javadoc)
	 * 
	 * @see model.IGenerator#generate()
	 */
	public Box[][] generate() {
		Box[][] board = new Box[boardWidth][boardHeight];
		for (int i = 0; i < boardWidth; i++) {
			for (int j = 0; j < boardHeight; j++) {
				board[i][j] = new Box(false);
			}
		}
		board[1][1] = new Box(true);
		return board;
	}
}
